#### ODABRANE TEME VN (vremenski nizovi) ####



#################################################################################

# Instalirati sljedece pakete prije provodenja naredbi (ako prvi puta radite u R-u):

paketi<-c("car","dummies","dynlm","lmtest","lmSupport","Matrix","matrixStats",         
          "Deriv","moments","normtest","quantmod","QuantPsyc","tseries","urca","vars",
           "xlsx","stats","stats4","forecast","readxl","gap","strucchange","sandwich","car",
           "vars","tsutils","sandwich")

install.packages(paketi,dependencies = T)

library("remotes")
install_github("cran/FitAR")
install_github("cran/FitARMA")

#Napomena: Kada se prvi puta instaliraju svi paketi zajedno, instalacija traje dulje vrijeme.

#################################################################################

setwd("~/__Tihana 2")


#################################################################################
# POGLAVLJE 1
#################################################################################

#Slika 1.1

library(readxl)
library(forecast)
iip<-read.table("iip.txt",header=T,sep="\t")
IIP<-ts(iip$IIP,start=c(1998,1),frequency=12)
bdp<-read.table("bdp.txt",header=T,sep="\t")
BDP<-ts(bdp$BDP,start=c(1995,1),frequency = 4)
BDP<-BDP/decompose(BDP,type="multiplicative")$season
tecaj <- read_excel("tecaj.xlsx",sheet="List1")
tecaj<-ts(tecaj$tecaj,start=c(2000,1),frequency = 12)
dolasci<-read_excel("msi-turizam.xlsx",sheet="List1")
dolasci<-ts(dolasci$`dolasci, ukupno u 000`,start=c(2010,1),frequency = 12)
des_dolasci<-ma(dolasci,12,centre=T)

par(mfrow = c(2,2),oma=c(1,1,1,1),mar=c(2,2,2,2))
plot(IIP,xlab=NA,ylab=NA)
plot(BDP,xlab=NA,ylab=NA)
plot(tecaj,xlab=NA,ylab=NA)
plot(dolasci,xlab=NA,ylab=NA)
lines(des_dolasci,lty="dashed")
legend("topleft", legend=c("dolasci, ukupno u 000","desezonirano"),
       col=c("black", "black"), lty=c(1,2))

#################################################################################


#Slika 1.2.
iip<-read.table("iip.txt",header=T,sep="\t")
IIP<-ts(iip$IIP,start=c(1998,1),frequency=12)
plot(decompose(IIP,type="additive"))

#################################################################################

#Slika 1.3

bdp<-read.table("bdp.txt",header=T,sep="\t")
BDP<-ts(bdp$BDP,start=c(1995,1),frequency = 4)

stopa_a<-diff(log(BDP))
stopa_b<-diff(log(BDP),4)
par(mfrow = c(1,2),oma=c(1,1,1,1),mar=c(2,2,2,2))
plot(stopa_a)
plot(stopa_b)


#################################################################################

#Primjer 1.1.

#Slika 1.4
iip<-read.table("iip.txt",header=T,sep="\t")
IIP<-ts(iip$IIP,start=c(1998,1),frequency=12)
library(forecast)
binarne<-seasonaldummy(IIP)

#Slika 1.5. je tablica binarne u gornjem desnom panelu R-studija


#Slika 1.6.
summary(lm(IIP~binarne))

#Slika 1.7.
library(tsutils)
sve.binarne<-seasdummy(length(IIP),12,y=IIP,type="bin",full=T)
summary(lm(IIP~0+sve.binarne))


#################################################################################

#Primjer 1.2
iip<-read.table("iip.txt",header=T,sep="\t")
IIP<-ts(iip$IIP,start=c(1998,1),frequency=12)
library(forecast)
binarne<-seasonaldummy(IIP)

#Slika 1.8.
trend<-ts(1:length(IIP),start=c(1998,1),frequency=12)
bin1<-c(rep(0,120),rep(1,72),rep(0,272-120-72))
bin2<-c(rep(0,120+72),rep(1,272-120-72))
summary(m1<-lm(IIP~binarne+trend+I(bin1*trend)+I(bin2*trend)))


#################################################################################

#Primjer 1.3

iip<-read.table("iip.txt",header=T,sep="\t")
IIP<-ts(iip$IIP,start=c(1998,1),frequency=12)
library(forecast)
binarne<-seasonaldummy(IIP)
trend<-ts(1:length(IIP),start=c(1998,1),frequency=12)
bin1<-c(rep(0,120),rep(1,72),rep(0,272-120-72))
bin2<-c(rep(0,120+72),rep(1,272-120-72))
summary(m1<-lm(IIP~binarne+trend+I(bin1*trend)+I(bin2*trend)))

#Slika 1.9.

library(car)
ogranicenje<-c("binarneJan=0","binarneFeb=0","binarneMar=0",
               "binarneApr=0","binarneMay=0","binarneJun=0",
               "binarneJul=0","binarneAug=0","binarneSep=0",
               "binarneOct=0","binarneNov=0")
linearHypothesis(m1,ogranicenje,type="Chisq")




#################################################################################

#Primjer 1.4

iip<-read.table("iip.txt",header=T,sep="\t")
IIP<-ts(iip$IIP,start=c(1998,1),frequency=12)
library(forecast)
binarne<-seasonaldummy(IIP)

#Slika 1.10

model<-lm(IIP~binarne)

binarne<-seasonaldummy(ts(273:276,start=c(2020,9),frequency=12))
binarne<-ts(binarne,start=c(2020,9),frequency=12)
prognoza<-predict(model,newdata=binarne)
procjene<-(fitted(model))
zajedno<-c(procjene,prognoza)
zajedno<-ts(zajedno,start=c(1998,1),frequency=12)
cbind(IIP,zajedno)

#Slika 1.11. je zadnji dio ispisa koji se dobije s naredbom cbind(IIP,zajedno)




#################################################################################

#Primjer 1.5

#Slika 1.12.


crobex<-read.table("crobex.txt",header=T,sep="\t")
prinos<-c(NA,diff(log(crobex$Crobex))*100)
cro<-lm(prinos~0+pon+uto+sri+cet+pet,data=crobex)
#Newey-West korekcija:
library(sandwich)
mat<-NeweyWest(cro,lag=1)
library(lmtest)
coeftest(cro,vcov=mat)



#################################################################################

# 1.4. Primjer

bdp<-read.table("bdp.txt",header=T,sep="\t")
bdp<-ts(bdp$BDP,start=c(1995,1),frequency = 4)

#SLika 1.13.
par(mfrow = c(1,1),oma=c(1,0,0,1),mar=c(1,4,1,1))
plot(bdp,xlab="godine",ylab="BDP")

#Slika 1.14 i 1.15.
library(forecast)
bin<-seasonaldummy(bdp)
bin2<-c(rep(1,52),rep(0,102-52))
trend<-ts(1:102,start=c(1995,1),frequency = 4)
m1<-lm(bdp~bin)
m2<-lm(bdp~bin+I(bin*bin2))
m3<-lm(bdp~bin+trend+I(bin*bin2)+I(trend*bin2))
library(stargazer)
stargazer(list(m1,m2,m3),type="text")

#Slika 1.16


lines(ts(fitted(m1),start=c(1995,1),frequency = 4),lty="dashed")
lines(ts(fitted(m2),start=c(1995,1),frequency = 4),col="grey")
lines(ts(fitted(m3),start=c(1995,1),frequency = 4),col="black",type="b",lty=1)
legend("topleft", legend=c("BDP", "m1","m2","m3"),
       col=c("black", "black","grey","black"), lty=c(1,2,1,3))

#Slika 1.17

library(car)
ogr<-c("binQ1=0","binQ2=0","binQ3=0")
linearHypothesis(m3,ogr,type="Chisq")

#Slika 1.18.

bin<-seasonaldummy(ts(103:104,start=c(2020,3),frequency=4))
bin2<-c(1,1)
trend<-ts(103:104,start=c(2020,3),frequency = 4)
novo<-cbind(bin,bin2,trend)
predict(m3,newdata=novo)

#Slika 1.19.

Box.test(resid(m3),lag=2,type="Ljung-Box")

#SLika 1.20
bin<-seasonaldummy(bdp)
bin2<-c(rep(1,52),rep(0,102-52))
trend<-ts(1:102,start=c(1995,1),frequency = 4)
bptest<-lm(residuals(m3)^2~bin+trend+I(bin*bin2)+I(trend*bin2))
nobs(bptest)*(summary(bptest))$r.squared
1-pchisq(nobs(bptest)*(summary(bptest))$r.squared,8)


#Slika 1.21.

#White korekcija:
library(car)
mat<-hccm(m3,type="hc0")
#t-test :
library(lmtest)

#Slika 1.22 lijevi panel:

coeftest(m3)

#Slika 1.22. desni panel:

coeftest(m3,vcov=mat)

##############################################################################

# 1.5. Pitanja za ponavljanje, zadatak 12:


bdp<-read.table("bdp_agregati.txt",header=T,sep="\t")
izvoz<-ts(bdp$izvoz,start=c(1995,1),frequency = 4)
plot(izvoz)

library(forecast)
binarne<-seasonaldummy(izvoz)
trend<-ts(1:length(izvoz),start=c(1995,1),frequency = 4)
bin2<-c(rep(0,52),rep(1,length(izvoz)-52))

#procjena i usporedba 4 modela:
m1<-lm(izvoz~binarne)
m2<-lm(izvoz~trend+binarne)
m3<-lm(izvoz~trend+binarne+I(trend*bin2))
m4<-lm(izvoz~trend+binarne+I(binarne*bin2))

library(stargazer)
stargazer(list(m1,m2,m3,m4),type="text")

library(car)
ogr<-c("binarneQ1=0","binarneQ2=0","binarneQ3=0")
linearHypothesis(m1,ogr,type="Chisq")

ogr<-"I(trend * bin2)"
linearHypothesis(m3,ogr,type="Chisq")



binarne<-seasonaldummy(ts(103:110,start=c(2020,3),frequency=4))
binarne<-ts(binarne,start=c(2020,3),frequency=4)
trend<-ts(103:110,start=c(2020,3),frequency=4)
bin2<-ts(rep(1,8),start=c(2020,3),frequency=4)
novo<-cbind(binarne,trend,bin2)
prognoza<-predict(m4,newdata=novo)
procjene<-(fitted(m4))
zajedno<-c(procjene,prognoza)
zajedno<-ts(zajedno,start=c(1995,1),frequency=4)
cbind(izvoz,zajedno)


stopa1<-diff(log(izvoz))
stopa1<-ts(stopa1,start=c(1995,2),frequency = 4)
plot(stopa1)

stopa2<-diff(log(izvoz),lag=4)
stopa2<-ts(stopa2,start=c(1996,1),frequency = 4)
plot(stopa2)

############################################################################

#Primjer 1.6.


bdp<-read.table("bdp.txt",header=T,sep="\t")
bdp<-ts(bdp$BDP,start=c(1995,1),frequency = 4)

#Slika 1.23. i 1.24:

library(forecast)
bdp.pp<-ma(bdp,4,centre = T)
plot(bdp)
lines(bdp.pp,col="black",lty="dashed")
legend("topleft", legend=c("BDP", "MA"),col=c("black", "black"), lty=c(1,2))


############################################################################

#Primjer 1.7


bdp<-read.table("bdp.txt",header=T,sep="\t")
bdp<-ts(bdp$BDP,start=c(1995,1),frequency = 4)

#Slika 1.25, 1.26. i 1.27

plot(decompose(bdp,type="additive"))
plot(decompose(bdp,type="multiplicative"))

# Slika 1.28. i 1.29.

dekompozicija<-decompose(bdp,type="multiplicative")
desezonirani.bdp<-bdp/dekompozicija$seasonal

plot(bdp,xlab="Godina",ylab="BDP")
lines(desezonirani.bdp,col="black",lty="dashed")
legend("topleft", legend=c("BDP", "des BDP"),col=c("black", "black"), lty=c(1,2))

#Slika 1.30
dekompozicija$seasonal[1:4]
stope<-(dekompozicija$seasonal-1)*100
stope[1:4]


############################################################################

# 1.6.3. Primjer

#Slika 1.31. i 1.32

bdp<-read.table("bdp_agregati.txt",header=T,sep="\t")
uvoz<-ts(bdp$uvoz,start=c(1995,1),frequency = 4)
desezonirani.uvoz<-uvoz/decompose(uvoz,type="multiplicative")$seasonal
plot(uvoz)

#slika 1.33
plot(dekompozicija<-decompose(uvoz,type="multiplicative"))

#Slika 1.34. i 1.35.
plot(uvoz, xlab="Godina", ylab="uvoz",col="grey",lwd=2)
lines(desezonirani.uvoz,col="black",lty="dashed")
legend("topleft",legend=c("uvoz","des uvoz"),col=c("grey","black"),lty=c(2,2),lwd=c(2,1))

#Slika 1.36.
dekompozicija$seasonal[1:4]
stope<-(dekompozicija$seasonal-1)*100
stope[1:4]


############################################################################

# 1.7. Pitanja za ponavljanje, zadatak 4


bdp<-read.table("bdp_agregati.txt",header=T,sep="\t")
izvoz<-ts(bdp$izvoz,start=c(1995,1),frequency = 4)
plot(izvoz)
lines(ma(izvoz,4,centre=T),type="l",lty="dashed")
legend("topleft",legend=c("izvoz","MA"),col=c("black","black"),lty=c(2,2),lwd=c(1,2))

plot(dekompozicija<-decompose(izvoz,type="multiplicative"))

plot(izvoz,col="grey")
lines(izvoz/decompose(izvoz,type="multiplicative")$seasonal,lty="dashed")
legend("topleft",legend=c("uvoz","des uvoz"),col=c("grey","black"),lty=c(1,2),lwd=c(2,1))

#stope
dekompozicija$seasonal[1:4]
stope<-(dekompozicija$seasonal-1)*100
stope[1:4]



############################################################################

# Primjer 1.8.


bdp<-read.table("bdp_agregati.txt",header=T,sep="\t")
drzavna<-ts(bdp$drzava,start=c(1995,1),frequency = 4)

#Slika 1.37 i 1.38.

library(forecast)
acf.drz<-Acf(drzavna,lag.max = 20)
acf.drz<-Acf(drzavna,lag.max = 8)
acf.koeficijenti<-matrix(acf.drz[["acf"]])
t(acf.koeficijenti)

#slika 1.39. i 1.40

stopa<-diff(log(drzavna),4)
acf.drz<-Acf(stopa,lag.max = 20)
acf.drz<-Acf(stopa,lag.max = 8)
acf.koeficijenti<-matrix(acf.drz[["acf"]])
t(acf.koeficijenti)

#Slika 1.41. lijevi panel
prosjek1<-mean(drzavna)
prosjek1<-ts(rep(prosjek1,102),start=c(1995,1),frequency = 4)
plot(drzavna)
lines(prosjek1)

#slika 1.41. desni panel

prosjek2<-mean(stopa)
prosjek2<-ts(rep(prosjek2,101),start=c(1995,2),frequency = 4)
plot(stopa)
lines(prosjek2)


############################################################################

# Primjer 1.9.


bdp<-read.table("bdp_agregati.txt",header=T,sep="\t")
drzavna<-ts(bdp$drzava,start=c(1995,1),frequency = 4)
stopa<-diff(log(drzavna),4)


#Slika 1.42. i 1.43

pacf.drz<-Pacf(drzavna,lag.max=20)
pacf.drz<-Pacf(stopa,lag.max = 8)
pacf.koeficijenti<-matrix(pacf.drz[["acf"]])
t(pacf.koeficijenti)

#Slika 1.44 i 1.45


acf.drz<-Pacf(stopa,lag.max = 20)
acf.drz<-Pacf(stopa,lag.max = 8)
acf.koeficijenti<-matrix(acf.drz[["acf"]])
t(acf.koeficijenti)


############################################################################

# Primjer 1.10

bdp<-read.table("bdp_agregati.txt",header=T,sep="\t")
drzavna<-ts(bdp$drzava,start=c(1995,1),frequency = 4)
stopa<-diff(log(drzavna),4)


#slika 1.46


Box.test(drzavna,lag=3,type="Box-Pierce")
Box.test(drzavna,lag=3,type="Ljung-Box")


#Slika 1.47.


Box.test(stopa,lag=3,type="Box-Pierce")
Box.test(stopa,lag=3,type="Ljung-Box")



############################################################################

# Primjer 1.11

#Slika 1.48. i 1.49
set.seed(0)
epsilon<-rnorm(100,0,1)
epsilon<-ts(epsilon,start=c(2011,9),frequency=12)
plot(epsilon)

#spremiti epsilon za primjere ispod


#slika 1.50 i 1.51.

library(forecast)
par(mfrow = c(1, 2))
Acf(epsilon,lag.max=10)
Pacf(epsilon,lag.max=10)
par(mfrow = c(1, 1))


#slika 1.52

Box.test(epsilon,lag = 10,type="Box-Pierce")
Box.test(epsilon,lag = 10,type="Ljung-Box")



############################################################################

# Primjer 1.12

#Slika 1.53 i 1.54

#spremiti epsilon iz primjera 1.11

library(stats)
y<-arima.sim(model=list(ar = 0.88), n=100, innov = epsilon) 
y<-1+y
y<-ts(y,start=c(2011,9),frequency=12)
plot(y)

#Slika 1.55

library(forecast)
par(mfrow = c(1, 2))
Acf(y,lag.max=10)
Pacf(y,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.56.

Box.test(y,lag = 10,type="Box-Pierce")
Box.test(y,lag = 10,type="Ljung-Box")

#Slika 1.57. i 1.58

ar_1<-auto.arima(y,d=0)  # ako tu ne dobijete ar(1) (provjeriti uz summary(ar_1)), onda "rucno"
#Procijeniti uz ar_1<-arima(y,order=c(1,0,0))
summary(ar_1)
korijeni<-autoplot(ar_1)
plot(korijeni)
korijeni$data$roots


############################################################################

# Primjer 1.13

#spremiti epsilon iz primjera 1.11

library(stats)
y<-arima.sim(model=list(ar = -0.88), n=100, innov = epsilon)
y<-1+y
y<-ts(y,start=c(2011,9),frequency=12)

#Slika 1.59.

plot(y)

#Slika 1.60

library(forecast)
par(mfrow = c(1, 2))
Acf(y,lag.max=10)
Pacf(y,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.61

Box.test(y,lag = 10,type="Box-Pierce")
Box.test(y,lag = 10,type="Ljung-Box")


ar_1<-auto.arima(y,d=0)  # ako tu ne dobijete ar(1) (provjeriti uz summary(ar_1)), onda "rucno"
#Procijeniti uz ar_1<-arima(y,order=c(1,0,0))
summary(ar_1)
korijeni<-autoplot(ar_1)
korijeni$data$roots

#Slika 1.62.
plot(korijeni)



############################################################################

# Primjer 1.14

#spremiti epsilon iz primjera 1.11


library(stats)
y<-arima.sim(model=list(ar=c(0.6,-0.5)), n=100, innov = epsilon)
y<-1+y
y<-ts(y,start=c(2011,9),frequency=12)

#Slika 1.63.

plot(y)

#Slika 1.64.

library(forecast)
par(mfrow = c(1, 2))
Acf(y,lag.max=10)
Pacf(y,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.65 i 1.66
ar_2<-auto.arima(y,d=0)  # ako tu ne dobijete ar(2) (provjeriti uz summary(ar_2)), onda "rucno"
#Procijeniti uz ar_2<-arima(y,order=c(2,0,0))
summary(ar_2)
korijeni<-autoplot(ar_2)
plot(korijeni)
korijeni$data$roots




############################################################################

# Primjer 1.15


#spremiti epsilon iz primjera 1.11

#Slika 1.67 i 1.68
y<- arima.sim(model = list(ma =0.8), n = 100,innov=epsilon)
y<-1+y
y<-ts(y,start=c(2011,9),frequency=12)
plot(y)

#slika 1.69 
library(forecast)
par(mfrow = c(1, 2))
Acf(y,lag.max=10)
Pacf(y,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.70 i 1.71

ma_1<-auto.arima(y,d=0)   # ako tu ne dobijete ma(1) (provjeriti uz summary(ma_1)), onda "rucno"
#Procijeniti uz ma_1<-arima(y,order=c(0,0,1))
summary(ma_1)
korijeni<-autoplot(ma_1)
plot(korijeni)
korijeni$data$roots



############################################################################

# Primjer 1.16


#spremiti epsilon iz primjera 1.11

#Slika 1.72
y<- arima.sim(model = list(ma = -0.8), n = 100,innov=epsilon)
y<-1+y
y<-ts(y,start=c(2011,9),frequency=12)
plot(y)

#slika 1.73 
library(forecast)
par(mfrow = c(1, 2))
Acf(y,lag.max=10)
Pacf(y,lag.max=10)
par(mfrow = c(1, 1))




############################################################################

# Primjer 1.17


#spremiti epsilon iz primjera 1.11


#Slika 1.74. i 1.75
y<- arima.sim(model = list(ma =c( 0.8,-0.2)), n = 100,innov=epsilon)
y<-1+y
y<-ts(y,start=c(2011,9),frequency=12)
plot(y)

#Slika 1.76 
library(forecast)
par(mfrow = c(1, 2))
Acf(y,lag.max=10)
Pacf(y,lag.max=10)
par(mfrow = c(1, 1))

ma_2<-arima(y,order=c(0,0,2))
korijeni<-autoplot(ma_2)

#Slika 1.77.
korijeni$data$roots 

#Slika 1.78
plot(korijeni)



############################################################################

# Primjer 1.18

#Slika 1.79

library("FitARMA")
z<-ImpulseCoefficientsARMA(phi=.75, theta=0, lag.max=10)
plot(z,type="l",ylab="IRF",xlab="pomak")

#Slika 1.80

z1 <- ImpulseCoefficientsARMA(phi=0.75, theta=0,
              lag.max=10)
z2 <- ImpulseCoefficientsARMA(phi=-0.75, theta=0,
              lag.max=10)
z3 <- ImpulseCoefficientsARMA(phi=0, theta=-0.75,
              lag.max=10)
z4 <- ImpulseCoefficientsARMA(phi=0, theta=+0.75,
              lag.max=10)
z5 <- ImpulseCoefficientsARMA(phi=c(0.75,-0.2), theta=0,
              lag.max=10)
z6 <- ImpulseCoefficientsARMA(phi=0, theta=c(-0.75,+0.2),
              lag.max=10)

par(mfrow = c(3, 2),oma=c(0,0,0,0),mar=c(2,4,3,1))
plot(z1,type="l",ylab="a",xlab="pomak")
abline(h=0,lty="dashed")
plot(z2,type="l",ylab="b",xlab="pomak")
abline(h=0,lty="dashed")
plot(z3,type="l",ylab="c",xlab="pomak")
abline(h=0,lty="dashed")
plot(z4,type="l",ylab="d",xlab="pomak")
abline(h=0,lty="dashed")
plot(z5,type="l",ylab="e",xlab="pomak")
abline(h=0,lty="dashed")
plot(z6,type="l",ylab="f",xlab="pomak")
abline(h=0,lty="dashed")



############################################################################

# Primjer 1.19

#Slika 1.81
library("FitARMA")

z7 <- ImpulseCoefficientsARMA(phi=0.2, theta=0,
              lag.max=10)
z8 <- ImpulseCoefficientsARMA(phi=0.95,theta=0,
                              lag.max=10)
par(mfrow = c(1, 2),oma=c(0,0,0,0),mar=c(2,4,2,1))
plot(z7,type="l",ylab="0.2",xlab="pomak")
abline(h=0,lty="dashed")
plot(z8,type="l",ylab="0.95",xlab="pomak")
abline(h=0,lty="dashed")



############################################################################

# Primjer 1.20

#spremiti epsilon iz primjera 1.11


#slika 1.82 i 1.83
ar_ma<-arima.sim(model=list(ar=0.8,ma=0.8),n=100,innov=epsilon)
ar_ma<-2+ar_ma
ar_ma<-ts(ar_ma,start=c(2011,9),frequency=12)
plot(ar_ma)

#slika 1.84

library(forecast)
par(mfrow = c(1, 2))
Acf(ar_ma,lag.max=10)
Pacf(ar_ma,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.85 i 1.86
ar_ma_11<-arima(ar_ma,order=c(1,0,1))
korijeni<-autoplot(ar_ma_11)
plot(korijeni)
korijeni$data$roots

#slika 1.87.

imp<- ImpulseCoefficientsARMA(phi=.775, theta=-0.8491,
                              lag.max=10)
plot(imp,type="l")
abline(h=0,lty="dashed")




############################################################################

# 1.9.9 Primjer


nizovi<-read.table("gen_nizovi.txt",header=T,sep="\t")

#Slika 1.88.

y1<-ts(nizovi$Y1,start=c(2003,9),frequency=12)
plot(y1)

#Slika 1.89.
library(forecast)
par(mfrow = c(1, 2))
Acf(y1,lag.max=10)
Pacf(y1,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.90

Box.test(y1,lag=10,type="Box-Pierce")
Box.test(y1,lag=10,type="Ljung-Box")

#Slika 1.91.
m1<-auto.arima(y1,d=0)
summary(m1)
korijeni<-autoplot(m1)
plot(korijeni)
korijeni$data$roots

#slika 1.92

imp<- ImpulseCoefficientsARMA(phi=0.9302, theta=0,
                              lag.max=10)
plot(imp,type="l")


#Slika 1.93.

y2<-ts(nizovi$Y2,start=c(2003,9),frequency=12)
plot(y2)

#Slika 1.94.
library(forecast)
par(mfrow = c(1, 2))
Acf(y2,lag.max=10)
Pacf(y2,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.95.

Box.test(y2,lag=10,type="Box-Pierce")
Box.test(y2,lag=10,type="Ljung-Box")

#Slika 1.96.
m1<-auto.arima(y2,d=0)
summary(m1)
korijeni<-autoplot(m1)
plot(korijeni)
korijeni$data$roots

#slika 1.97.

imp<- ImpulseCoefficientsARMA(phi=-0.8258, theta=0,
                              lag.max=10)
plot(imp,type="l")
abline(h=0,lty="dashed")


#Slika 1.98.

y3<-ts(nizovi$Y3,start=c(2003,9),frequency=12)
plot(y3)

#Slika 1.99.
library(forecast)
par(mfrow = c(1, 2))
Acf(y3,lag.max=10)
Pacf(y3,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.100.

Box.test(y3,lag=10,type="Box-Pierce")
Box.test(y3,lag=10,type="Ljung-Box")

#Slika 1.101
m1<-auto.arima(y3,d=0)
summary(m1)
korijeni<-autoplot(m1)
plot(korijeni)
korijeni$data$roots

#slika 1.102.

imp<- ImpulseCoefficientsARMA(phi=c(.6661,-.4107), theta=0,
                              lag.max=10)
plot(imp,type="l")
abline(h=0,lty="dashed")



#Slika 1.103

y4<-ts(nizovi$Y4,start=c(2003,9),frequency=12)
plot(y4)

#Slika 1.104
library(forecast)
par(mfrow = c(1, 2))
Acf(y4,lag.max=10)
Pacf(y4,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.105.

Box.test(y4,lag=10,type="Box-Pierce")
Box.test(y4,lag=10,type="Ljung-Box")

#Slika 1.106.
m1<-arima(y4,order=c(0,0,1))
summary(m1)
korijeni<-autoplot(m1)
plot(korijeni)
korijeni$data$roots

#slika 1.107.

imp<- ImpulseCoefficientsARMA(phi=0, theta=-0.8799,
                              lag.max=10)
plot(imp,type="l")
abline(h=0,lty="dashed")


#Slika 1.108.

y5<-ts(nizovi$Y5,start=c(2003,9),frequency=12)
plot(y5)

#Slika 1.109
library(forecast)
par(mfrow = c(1, 2))
Acf(y5,lag.max=10)
Pacf(y5,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.110.

Box.test(y5,lag=10,type="Box-Pierce")
Box.test(y5,lag=10,type="Ljung-Box")

#Slika 1.111.
m1<-arima(y5,order=c(0,0,1))
summary(m1)
korijeni<-autoplot(m1)
plot(korijeni)
korijeni$data$roots

#slika 1.112.

imp<- ImpulseCoefficientsARMA(phi=0, theta=0.8636,
                              lag.max=10)
plot(imp,type="l")
abline(h=0,lty="dashed")




#Slika 1.113.

y6<-ts(nizovi$Y6,start=c(2003,9),frequency=12)
plot(y5)

#Slika 1.114.
library(forecast)
par(mfrow = c(1, 2))
Acf(y6,lag.max=10)
Pacf(y6,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.115.

Box.test(y6,lag=10,type="Box-Pierce")
Box.test(y6,lag=10,type="Ljung-Box")

#Slika 1.116.
m1<-arima(y6,order=c(1,0,1))
summary(m1)
korijeni<-autoplot(m1)
plot(korijeni)
korijeni$data$roots

#slika 1.117.

imp<- ImpulseCoefficientsARMA(phi=0.646, theta=-0.6499,
                              lag.max=10)
plot(imp,type="l")
abline(h=0,lty="dashed")



#Slika 1.118.

y7<-ts(nizovi$Y7,start=c(2003,9),frequency=12)
plot(y7)

#Slika 1.119.
library(forecast)
par(mfrow = c(1, 2))
Acf(y7,lag.max=10)
Pacf(y7,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.120.

Box.test(y7,lag=10,type="Box-Pierce")
Box.test(y7,lag=10,type="Ljung-Box")

#Slika 1.121.
m1<-arima(y7,order=c(0,0,2))
summary(m1)
korijeni<-autoplot(m1)
plot(korijeni)
korijeni$data$roots

#slika 1.122.

imp<- ImpulseCoefficientsARMA(phi=0, theta=c(-.5679,.4321),
                              lag.max=10)
plot(imp,type="l")
abline(h=0,lty="dashed")


#############################################################################

# 1.9.10. Pitanja za ponavljanje, zadatak 35:


nizovi<-read.table("vremenski2.txt",header=T,sep="\t")
y1<-ts(nizovi$y1,start=c(2003,9),frequency=12)
y2<-ts(nizovi$y2,start=c(2003,9),frequency=12)
y3<-ts(nizovi$y3,start=c(2003,9),frequency=12)
y4<-ts(nizovi$y4,start=c(2003,9),frequency=12)


plot(y1)
plot(y2)
plot(y3)
plot(y4)

library(forecast)
par(mfrow = c(1, 2))
Acf(y1,lag.max=10)
Pacf(y1,lag.max=10)
par(mfrow = c(1, 1))

par(mfrow = c(1, 2))
Acf(y2,lag.max=10)
Pacf(y2,lag.max=10)
par(mfrow = c(1, 1))


par(mfrow = c(1, 2))
Acf(y3,lag.max=10)
Pacf(y3,lag.max=10)
par(mfrow = c(1, 1))


par(mfrow = c(1, 2))
Acf(y4,lag.max=10)
Pacf(y4,lag.max=10)
par(mfrow = c(1, 1))

Box.test(y1,lag=10,type="Box-Pierce")
Box.test(y1,lag=10,type="Ljung-Box")


Box.test(y2,lag=10,type="Box-Pierce")
Box.test(y2,lag=10,type="Ljung-Box")


Box.test(y3,lag=10,type="Box-Pierce")
Box.test(y3,lag=10,type="Ljung-Box")


Box.test(y4,lag=10,type="Box-Pierce")
Box.test(y4,lag=10,type="Ljung-Box")

#####################################################################

# 1.9.10. Pitanja za ponavljanje, zadatak 36:

x1<- ImpulseCoefficientsARMA(phi=c(0.4), theta=0,
             lag.max=10)
x2 <- ImpulseCoefficientsARMA(phi=0.95, theta=0,
              lag.max=10)
x3 <- ImpulseCoefficientsARMA(phi=-0.4, theta=0,
              lag.max=10)
x4 <- ImpulseCoefficientsARMA(phi=0.9999, theta=0,
              lag.max=10)
x5 <- ImpulseCoefficientsARMA(phi=1.3, theta=0,
              lag.max=10)
x6 <- ImpulseCoefficientsARMA(phi=-1.3, theta=0,
              lag.max=10)


par(mfrow = c(3,2),oma=c(0,0,0,0),mar=c(2,4,2,1))
plot(x1,type="l",ylab="AR(1), 0.4",xlab="pomak")
abline(h=0,lty="dashed")
plot(x2,type="l",ylab="AR(1), 0.95",xlab="pomak")
abline(h=0,lty="dashed")
plot(x3,type="l",ylab="AR(1), -0.4",xlab="pomak")
abline(h=0,lty="dashed")
plot(x4,type="l",ylab="1",xlab="pomak")
abline(h=0,lty="dashed")
plot(x5,type="l",ylab="1.3",xlab="pomak")
abline(h=0,lty="dashed")
plot(x6,type="l",ylab="-1.3",xlab="pomak")
abline(h=0,lty="dashed")



############################################################################

# Primjer 1.21

#Slika 1.123. lijevi panel: 

set.seed(0)
epsilon<-rnorm(200,0,1)
epsilon<-ts(epsilon,start=c(2005,1),frequency = 12)
trend<-ts((1:200),start=c(2005,1),frequency = 12)
y1<-cumsum(5*epsilon)
y1<-ts(y1,start=c(2005,1),frequency = 12)
plot(y1,ylab=NA)

#Slika 1.123. desni panel: 

y2<-c((diff((y1/10))),-1.5*diff((y1)))
y2<-y2[100:300]
y2<-ts(y2,start=c(2005,1),frequency = 12)
plot(y2)

#Slika 1.124. 

library(forecast)
par(mfrow = c(1, 2))
Acf(y1,lag.max=10)
Acf(y2,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.125 lijevi panel

Box.test(y1,lag=10,type="Box-Pierce")
Box.test(y1,lag=10,type="Ljung-Box")


#Slika 1.125 desni panel

Box.test(y2,lag=10,type="Box-Pierce")
Box.test(y2,lag=10,type="Ljung-Box")

############################################################################

# Primjer 1.22

# imati spremeljen epsilon iz primjera 1.21.

#slika 1.126. lijevi panel:

y3<-ts(2+.8*trend+5*epsilon,start=c(2005,1),frequency = 12)
plot(y3)

#slika 1.126. desni panel:

y4<-ts(2+.2*trend+5*epsilon+.005*trend^2,start=c(2005,1),frequency = 12)
plot(y4)

#slika 1.127.

library(forecast)
par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf(y3,lag.max=10)
Acf(y4,lag.max=10)
par(mfrow = c(1, 1))


############################################################################

# Primjer 1.23

# imati spremljeno sve u primjeru 1.22

#Slika 1.128.

rez1<-resid(lm(y3~trend))
rez2<-resid(lm(y4~trend+I(trend^2)))
par(mfrow = c(1, 2),mar=c(2,2,1,2))
plot(rez1,type="l",ylab=NA)
plot(rez2,type="l",ylab=NA)

#Slika 1.129.

library(forecast)
par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf(rez1,lag.max=10)
Acf(rez2,lag.max=10)
par(mfrow = c(1, 1))

#Slika 1.130.

Box.test(rez1,lag = 10,type="Ljung-Box")
Box.test(rez2,lag = 10,type="Ljung-Box")


############################################################################

# Primjer 1.23

# imati spremeljen epsilon iz primjera 1.21.

#Slika 1.131.


y5<-2+cumsum(5*epsilon)
y5<-ts(y5,start=c(2005,1),frequency = 12)
y6<-20+cumsum(-.3*epsilon)
y6<-ts(y6,start=c(2005,1),frequency = 12)

par(mfrow = c(1, 2),mar=c(2,2,1,2))
plot(y5)
plot(y6)

#SLika 1.132.

par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf(y5,lag.max=10)
Acf(y6,lag.max=10)


############################################################################

# Primjer 1.24

#prvo provesti primjer 1.23

#Slika 1.133.

par(mfrow = c(1, 2),mar=c(2,2,1,2))
plot(diff(y5))
plot(diff(y6))

#Slka 1.134.
par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf(diff(y5),lag.max=10)
Acf(diff(y6),lag.max=10)


############################################################################

# Primjer 1.25

#prvo provesti primjer 1.23

#Slika 1.135.

par(mfrow = c(1, 2),mar=c(2,2,1,2))
plot(y5)
rez<-resid(lm(y5~trend))
rez<-ts(rez,start=c(2005,1),frequency = 12)
plot(rez)


############################################################################

# Primjer 1.26

#prvo provesti primjer 1.22

#Slika 1.136

par(mfrow = c(1, 2),mar=c(2,2,1,2))
plot(y3)
rez2<-(diff(y3))
rez2<-ts(rez2,start=c(2005,2),frequency = 12)
plot(rez2)


############################################################################

# Primjer 1.27

#Slika 1.137.

par(mfrow = c(1, 2),mar=c(2,2,1,2))
set.seed(0)
epsilon<-rnorm(200,0,1)
y7<-cumsum(epsilon)
y7<-ts(y7,start=c(2005,1),frequency = 12)
plot(y7)
dy7<-ts(diff(y7),start=c(2005,2),frequency=12)
plot(dy7)


#Slika 1.138
par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf((y7),lag.max=24)
Acf((dy7),lag.max=24)



############################################################################

# Primjer 1.28

# imati epsilon iz primjera 1.27.

#Slika 1.139
par(mfrow = c(1, 2),mar=c(2,2,1,2))

y8<-1+cumsum(epsilon)
y8<-ts(y8,start=c(2005,1),frequency=12)
plot(y8)
dy8<-ts(diff(y8),start=c(2005,2),frequency=12)
plot(dy8)


#Slika 1.140
par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf((y8),lag.max=24)
Acf((dy8),lag.max=24)



############################################################################

# Primjer 1.29

#Slika 1.141.

par(mfrow = c(1, 2),mar=c(2,2,1,2))
cro<-read.table("crobex_dnevno.txt",sep="\t",head=T)
cro<-ts(cro$Price,start=c(2018,1,2),frequency = 252)
plot(cro,xaxt="n",xlab=NA)
axis(1, at=2018:2020)
prinos<-ts(diff(cro),start=c(2018,1,3),frequency = 252)
plot(prinos,xaxt="n")
axis(1,at=2019:2020)


#Slika 1.142

par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf(cro,lag.max=30)
Acf(prinos,lag.max=30)


#Slika 1.143

par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf(prinos,lag.max=30)
Pacf(prinos,lag.max=30)



############################################################################

# 1.10.5. Primjer

#Slika 1.144., 1.145., 1.146. i 1.147.

nestac<-read.table("nestac.txt",head=T,sep="\t")
y1<-ts(nestac$y1,start=c(2005,1),frequency = 12)
y2<-ts(nestac$y2,start=c(2005,1),frequency = 12)
y3<-ts(nestac$y3,start=c(2005,1),frequency = 12)
plot(y1)
plot(y2)
plot(y3)

#Slika 1.148. i 1.149.

par(mfrow = c(1, 3),mar=c(2,2,1,2))
Acf(y1,20)
Acf(y2,20)
Acf(y3,20)

#Slika 1.150., 1.151., 1.152. i 1.153.

trend<-ts(1:length(y1),start=c(2005,1),frequency = 12)
rez1<-resid(lm(y1~trend))
rez2<-resid(lm(y2~trend+I(trend^2)))
dif<-diff(y3)
rez1<-ts(rez1,start=c(2005,1),frequency = 12)
rez2<-ts(rez2,start=c(2005,1),frequency = 12)
dif<-ts(dif,start=c(2005,2),frequency = 12)
plot(rez1)
plot(rez2)
plot(dif)

#Slika 1.154.

par(mfrow = c(1, 3),mar=c(2,2,1,2))
Acf(rez1,20)
Acf(rez2,20)
Acf(dif,20)



############################################################################

#Primjer 1.30.

#Slika 1.155.

set.seed(0)
y<-cumsum(rnorm(200,0,1))
x<-cumsum(rnorm(200,0,1))
summary(lm(y~x))
library(car)
durbinWatsonTest(lm(y~x))

#Slika 1.156.

par(mfrow = c(1, 2),mar=c(2,2,1,2))

plot(resid(lm(y~x)),type="l")
Acf(resid(lm(y~x)),20)


############################################################################

#Slika 1.157.

y<-rep(NA,200)
y[1]<-1
for (i in 2:200) {
  y[i]<-1+1.1*y[i-1]+epsilon[i]
}
plot(y,type="l")



############################################################################

#Primjer 1.31

# prvo provesti primjer 1.30

# Slika 1.158., 1.159, 1.160, 1.161. i 1.162.

library(urca)
summary(ur.df(x,type="trend",selectlags="BIC"))
summary(ur.df(x,type="drift",selectlags="BIC"))
summary(ur.df(x,type="none",selectlags="BIC"))

summary(ur.df(y,type="trend",selectlags="BIC"))
summary(ur.df(y,type="drift",selectlags="BIC"))
summary(ur.df(y,type="none",selectlags="BIC"))



############################################################################

#Primjer 1.32

# prvo provesti primjer 1.31
library(urca)

#Slika 1.163. i 1.164.

dx<-diff(x)
dy<-diff(y)
summary(ur.df(dx,type="none",selectlags="BIC"))
summary(ur.df(dy,type="none",selectlags="BIC"))



############################################################################

#Primjer 1.33

# prvo provesti 1.10.5. Primjer
library(urca)

#SLika 1.165., 1.166. 
summary(ur.df(y1,type="trend",selectlags="BIC"))
summary(ur.df(y1,type="none",selectlags="BIC"))

#SLika 1.167

summary(ur.df(resid(lm((y1~trend))),type="none",selectlags="BIC"))



############################################################################

#Primjer 1.34

#Slika 1.168. i 1.169.

set.seed(0)
epsilon<-rnorm(200,0,1)
summary(ur.df(epsilon,type="none",selectlags="BIC"))
epsilon2<-rnorm(200,5,1)
summary(ur.df(epsilon2,type="drift",selectlags="BIC"))



############################################################################

#Primjer 1.35

# prvo provesti 1.10.5. Primjer

#Slika 1.170 i 1.171

y2<-ts(nizovi$y2,start=c(2003,9),frequency=12)
summary(ur.df(y2,type="drift",selectlags="BIC"))
y4<-ts(nizovi$y4,start=c(2003,9),frequency=12)
summary(ur.df(y4,type="drift",selectlags="BIC"))


############################################################################

#Primjer 1.36

#Slika 1.172 i 1.173

ppp<-read.table("ppp.txt",header=T,sep="\t")
tecaj<-ts(ppp$tecaj, start=c(1998,1),frequency = 12)
library(forecast)
tecaj<-ma(tecaj,12,centre = T)

r<-log(tecaj)+log(ppp$aut)-log(ppp$cro)
plot(r,ylab=NA,xlab=NA)

#Slika 1.174.

par(mfrow = c(1, 2),mar=c(2,2,1,2))
Acf(r,lag.max=10)
Acf(r,lag.max=10)

#Slika 1.175
r<-r[7:267]
summary(ur.df(r,type="drift",selectlags="BIC"))


############################################################################

#Primjer 1.37

#Slika 1.176. i 1.177

cro<-read.table("crobex_dnevno.txt",sep="\t",head=T)
cro<-ts(cro$Price,start=c(2018,1,2),frequency = 252)
summary(ur.df(cro,type="drift",selectlags="BIC"))
summary(ur.df(diff(cro),type="none",selectlags="BIC"))


############################################################################

#Primjer 1.38


ppp<-read.table("ppp.txt",header=T,sep="\t")
tecaj<-ts(ppp$tecaj, start=c(1998,1),frequency = 12)
library(forecast)
tecaj<-ma(tecaj,12,centre = T)

#Slika 1.178. 
summary(ur.df(tecaj[7:267],type="trend",selectlags="BIC"))
summary(ur.df(tecaj[7:267],type="drift",selectlags="BIC"))


############################################################################

#Primjer 1.39


#Slika 1.179.

ardl<-read.table("ardl.txt",header=T, sep="\t")
ardl<-ts(ardl,start=c(2004,1),frequency = 12)

library(dynlm)

dynlm(y~L(y)+x+L(x),data=ardl)

#Slika 1.180

#ardl(1,1): y=a+bx+cx(-1)+dy(-1)

b<-0.8
c<-0.4
d<-0.7

irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
par(mfrow = c(1,1),oma=c(1,0,0,1),mar=c(1,4,1,1))
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")

#Slika 1.181


#kumulativno:
k_irf<-cumsum(irf)
plot(k_irf,type="l",ylab="K_IRF")



############################################################################

#Primjer 1.40

library(dynlm)

ardl<-read.table("ardl.txt",header=T, sep="\t")
ardl<-ts(ardl,start=c(2004,1),frequency = 12)

#Slika 1.182.

dynlm(z~L(z)+x,data=ardl)

#Slika 1.183.

#ardl(1,1): y=a+bx+cx(-1)+dy(-1)

b<-0.7
c<-0
d<-0.8

irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
par(mfrow = c(1,1),oma=c(1,0,0,1),mar=c(1,4,1,1))
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")

#Slika 1.184.

#kumulativno:
k_irf<-cumsum(irf)
plot(k_irf,type="l",ylab="K_IRF")



############################################################################

#Primjer 1.41.

library(dynlm)

ardl<-read.table("ardl.txt",header=T, sep="\t")
ardl<-ts(ardl,start=c(2004,1),frequency = 12)

#Slika 1.185.

dynlm(w~L(x)+x,data=ardl)

#Slika 1.186

#ardl(1,1): y=a+bx+cx(-1)+dy(-1)

b<-0.8
c<-0.6
d<-0

irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
par(mfrow = c(1,1),oma=c(1,0,0,1),mar=c(1,4,1,1))
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")

#Slika 1.187.

#kumulativno:
k_irf<-cumsum(irf)
plot(k_irf,type="l",ylab="K_IRF")



############################################################################

#Primjer 1.42.

library(dynlm)

par(mfrow = c(2,2),oma=c(1,0,0,1),mar=c(1,4,1,1))

b<-(0.8)
c<-0.6
d<-0.9

irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")

b<-(0.8)
c<-0.6
d<-0.1

irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")

b<-(-0.8)
c<-0.6
d<-0.1

irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")

b<-(-0.8)
c<-(0.2)
d<-(.4)

irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")


############################################################################

#Primjer 1.43

#Slika 1.189. i 1.190.

ardl2<-read.table("ardl2.txt",sep="\t",header=T)
dolasci<-ts(ardl2$S_dol,start=c(1998,1),frequency = 12)
dolasci<-dolasci/decompose(dolasci,type="multiplicative")$seasonal
cijene<-ts(ardl2$S_hicp,start=c(1998,1),frequency = 12)
cijene<-cijene/decompose(cijene,type="multiplicative")$seasonal

stopa.cijene<-diff(log(cijene),12)
stopa.dolasci<-diff(log(dolasci),12)

library(dynlm)
m1<-dynlm(stopa.dolasci~L(stopa.dolasci)+stopa.cijene+L(stopa.cijene))
m2<-dynlm(stopa.dolasci~L(stopa.dolasci)+stopa.cijene)
m3<-dynlm(stopa.dolasci~stopa.cijene+L(stopa.cijene))
library(stargazer)
stargazer(list(m1,m2,m3),type="text")

#Slika 1.191.

#ardl(1,1): y=a+bx+cx(-1)+dy(-1)
b<-(4.019)
c<-(-4.020)
d<-(0.239)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF_2",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")


#Slika 1.192.


#ardl(1,1): y=a+bx+cx(-1)+dy(-1)
b<-(0.147)
c<-(0)
d<-(0.231)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF_2",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")



#Slika 1.193.


#ardl(1,1): y=a+bx+cx(-1)+dy(-1)
b<-(3.819)
c<-(-3.792)
d<-(0)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF_2",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")


#Slika 1.193.


m4<-dynlm(stopa.dolasci~L(stopa.dolasci)+stopa.cijene+L(stopa.cijene),end=c(2007,12))
m5<-dynlm(stopa.dolasci~L(stopa.dolasci)+stopa.cijene+L(stopa.cijene),start=c(2008,1))
m4$coefficients
m5$coefficients

#SLika 1.194.

par(mfrow = c(1,2),oma=c(1,0,0,1),mar=c(1,4,1,1))

b<-(-2.609)
c<-(0.038)
d<-(0.141)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF_1",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")


b<-(3.697)
c<-(-5.354)
d<-(-0.029)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF_2",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")



#SLika 1.195.

par(mfrow = c(1,2),oma=c(1,0,0,1),mar=c(1,4,1,1))

b<-(-2.609)
c<-(0.038)
d<-(0.141)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
k_irf<-cumsum(irf)
plot(k_irf,type="l",ylab="K_IRF_1")


b<-(3.697)
c<-(-5.354)
d<-(-0.029)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
k_irf<-cumsum(irf)
plot(k_irf,type="l",ylab="K_IRF_2")

##############################################################################

# Primjer 1.44.


ardl2<-read.table("ardl2.txt",sep="\t",header=T)
dolasci<-ts(ardl2$I_dol,start=c(1998,1),frequency = 12)
dolasci<-dolasci/decompose(dolasci,type="multiplicative")$seasonal
cijene<-ts(ardl2$I_hicp,start=c(1998,1),frequency = 12)
cijene<-cijene/decompose(cijene,type="multiplicative")$seasonal

stopa.cijene<-diff(log(cijene),12)
stopa.dolasci<-diff(log(dolasci),12)

#Slika 1.196.


m6<-dynlm(stopa.dolasci~L(stopa.dolasci)+stopa.cijene,end=c(2007,12))
m7<-dynlm(stopa.dolasci~L(stopa.dolasci)+stopa.cijene,start=c(2008,1))
m6$coefficients
m7$coefficients


#Slika 1.197.


par(mfrow = c(1,2),oma=c(1,0,0,1),mar=c(1,4,1,1))

b<-(.406)
c<-(0)
d<-(-.087)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF_1",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")

b<-(-1.288)
c<-(0)
d<-(-0.079)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF_2",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")



##############################################################################

# Primjer 1.45.


ardl2<-read.table("ardl2.txt",sep="\t",header=T)
dolasci<-ts(ardl2$S_dol,start=c(1998,1),frequency = 12)
dolasci<-dolasci/decompose(dolasci,type="multiplicative")$seasonal
cijene<-ts(ardl2$S_hicp,start=c(1998,1),frequency = 12)
cijene<-cijene/decompose(cijene,type="multiplicative")$seasonal


#Slika 1.198.

library(lmtest)
grangertest(diff(cijene),diff(dolasci),1)
grangertest(diff(cijene),diff(dolasci),2)
grangertest(diff(cijene),diff(dolasci),3)

#Slika 1.199.

library(lmtest)
grangertest(diff(dolasci),diff(cijene),1)
grangertest(diff(dolasci),diff(cijene),2)
grangertest(diff(dolasci),diff(cijene),3)



ardl2<-read.table("ardl2.txt",sep="\t",header=T)
dolasci<-ts(ardl2$I_dol,start=c(1998,1),frequency = 12)
dolasci<-dolasci/decompose(dolasci,type="multiplicative")$seasonal
cijene<-ts(ardl2$I_hicp,start=c(1998,1),frequency = 12)


#Slika 1.200.

library(lmtest)
grangertest(diff(cijene),diff(dolasci),1)
grangertest(diff(cijene),diff(dolasci),2)
grangertest(diff(cijene),diff(dolasci),3)

#Slika 1.201.

library(lmtest)
grangertest(diff(dolasci),diff(cijene),1)
grangertest(diff(dolasci),diff(cijene),2)
grangertest(diff(dolasci),diff(cijene),3)



##############################################################################

# Primjer 1.46.

koin<-read.table("kointegracija.txt",header = T,sep="\t")
x<-ts(koin$x1,start=c(2002,1),frequency = 12)
y1<-ts(koin$y1,start=c(2002,1),frequency = 12)
y2<-ts(koin$y2,start=c(2002,1),frequency = 12)

#Slika 1.203. lijevi panel
library(urca)
summary(ur.df(x,type="drift",selectlags="BIC"))


#Slika 1.203. desni panel
summary(ur.df(y1,type="drift",selectlags="BIC"))


#Slika 1.204. lijevi panel
summary(ur.df(diff(x),type="none",selectlags="BIC"))


#Slika 1.204. desni panel
summary(ur.df(diff(y1),type="none",selectlags="BIC"))

#Slika 1.205.
rez1<-resid(lm(y1~x))
summary(ur.df(rez1,type="none",selectlags = "BIC"))

#Slika 1.206. lijevi panel
summary(ur.df(y2,type="drift",selectlags="BIC"))

#Slika 1.206. desni panel
summary(ur.df(diff(y2),type="none",selectlags="BIC"))


#Slika 1.207.
rez2<-resid(lm(y2~x))
summary(ur.df(rez2,type="none",selectlags = "BIC"))

#Slika 1.208
par(mfrow = c(1,2),oma=c(1,0,0,1),mar=c(1,4,1,1))

plot(rez1,type="l",ylab="rez1",xlab=NA)
plot(rez2,type="l",ylab="rez1",xlab=NA)



##############################################################################

# Primjer 1.48.

#Slika 1.209.

ardl2<-read.table("ardl2.txt",sep="\t",header=T)
dolasci<-ts(ardl2$S_dol,start=c(1998,1),frequency = 12)
dolasci<-dolasci/decompose(dolasci,type="multiplicative")$seasonal
cijene<-ts(ardl2$S_hicp,start=c(1998,1),frequency = 12)
cijene<-cijene/decompose(cijene,type="multiplicative")$seasonal


dolasci<-log(dolasci)
cijene<-log(cijene)
#dugi rok:
lm(dolasci~cijene)
reziduali<-ts(resid(lm(dolasci~cijene)),start=c(1998,1),frequency = 12)

#korekcija:
dynlm(diff(dolasci)~diff(cijene)+L(reziduali))



# za sliku 1.211. / slika 1.211.

dolasci<-ts(ardl2$I_dol,start=c(1998,1),frequency = 12)
dolasci<-dolasci/decompose(dolasci,type="multiplicative")$seasonal
cijene<-ts(ardl2$I_hicp,start=c(1998,1),frequency = 12)
cijene<-cijene/decompose(cijene,type="multiplicative")$seasonal


dolasci<-log(dolasci)
cijene<-log(cijene)
#dugi rok:
lm(dolasci~cijene)
reziduali<-ts(resid(lm(dolasci~cijene)),start=c(1998,1),frequency = 12)

#korekcija:
dynlm(diff(dolasci)~diff(cijene)+L(reziduali))

#########################################################################

# 1.16. Primjer

dinamicki<-read.table("rh_dinamicki.txt",sep="\t",header=T)
iip<-ts(dinamicki$hr_iip,start=c(2000,1),frequency = 12)
nez<-ts(dinamicki$hr_nez,start=c(2000,1),frequency = 12)

s.iip<-diff(log(iip/decompose(iip,type="multiplicative")$seasonal),12)
s.nez<-diff(log(nez/decompose(nez,type="multiplicative")$seasonal),12)

# Slika 1.212.
library(dynlm)
dynlm(s.nez~L(s.nez)+s.iip+L(s.iip))

#Slika 1.213.

b<-(-0.1141)
c<-(-.068)
d<-(0.9552)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")


#Slika 1.214.
irf<-cumsum(irf)
plot(x,irf,ylab="kumulativno_IRF",xlim=c(0,10),type="l")



# Slika 1.215
library(dynlm)
dynlm(s.nez~L(s.nez)+s.iip)

#Slika 1.216.
par(mfrow = c(1,2),oma=c(1,0,0,1),mar=c(1,4,1,1))

b<-(-0.145)
c<-(0)
d<-(0.963)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")

irf<-cumsum(irf)
plot(x,irf,ylab="kumulativno_IRF",xlim=c(0,10),type="l")



# Slika 1.217.
library(dynlm)
dynlm(s.nez~s.iip+L(s.iip))


#Slika 1.218.
par(mfrow = c(1,2),oma=c(1,0,0,1),mar=c(1,4,1,1))
b<-(-0.798)
c<-(-.927)
d<-(0)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")
irf<-cumsum(irf)
plot(x,irf,ylab="kumulativno_IRF",xlim=c(0,10),type="l")


#Slika 1.219.

m1<-dynlm(s.nez~L(s.nez)+s.iip+L(s.iip),end=c(2017,12))
m2<-dynlm(s.nez~L(s.nez)+s.iip+L(s.iip),start=c(2008,1),end=c(2015,12))
m3<-dynlm(s.nez~L(s.nez)+s.iip+L(s.iip),start=c(2016,1))
library(stargazer)
stargazer(list(m1,m2,m3),type="text")

# Slika 1.220.
b<-(-.402)
c<-(-.168)
d<-(1.008)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))

x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")
b<-(-.052)
c<-(-.083)
d<-(0.953)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
lines(x,irf,col="grey")
b<-(-.143)
c<-(-.189)
d<-(0.886)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
lines(x,irf,col="black",lty="dashed")

legend(8,-.3,legend=c("1","2","3"),
       col=c( "grey","black","black"), lty=c(1,2,1))


# Slika 1.221.

grangertest(s.iip,s.nez,1)
grangertest(s.iip,s.nez,2)
grangertest(s.iip,s.nez,3)


# Slika 1.222.

grangertest(s.nez,s.iip,1)
grangertest(s.nez,s.iip,2)
grangertest(s.nez,s.iip,3)



iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal

#Slika 1.223.

lm(nez~iip)

rez<-resid(lm(nez~iip))
rez<-ts(rez,start=c(2001,1),frequency = 12)
library(dynlm)
dynlm(diff(nez)~diff(iip)+L(rez))

# slika 1.224. lijevi panel:

summary(ur.df(iip,type="drift",selectlags = "BIC"))

# slika 1.224. desni panel:

summary(ur.df(nez,type="drift",selectlags = "BIC"))

# slika 1.225. lijevi panel:

summary(ur.df(diff(iip),type="none",selectlags = "BIC"))

# slika 1.225. desni panel:

summary(ur.df(diff(nez),type="none",selectlags = "BIC"))

#Slika 1.226.

rez2<-resid(lm(nez~iip))
summary(ur.df(rez2,type="none",selectlags = "BIC"))



#########################################################################

#Primjer 1.49.


#Slika 1.227. 

nizovi<-read.table("gen_nizovi.txt",header=T,sep="\t")

y<-ts(nizovi$Y1,start=c(2003,9),frequency=12)

library("ICglm")

ar_1<-arima(y,order=c(1,0,0))
ar_2<-arima(y,order=c(2,0,0))
ma_1<-arima(y,order=c(0,0,1))
ma_2<-arima(y,order=c(0,0,2))
arma<-arima(y,order=c(1,0,1))

aic_ar_1<-AIC(ar_1);bic_ar_1<-BIC(ar_1);hqc_ar_1<-HQIC(ar_1)
aic_ar_2<-AIC(ar_2);bic_ar_2<-BIC(ar_2);hqc_ar_2<-HQIC(ar_2)
aic_ma_1<-AIC(ma_1);bic_ma_1<-BIC(ma_1);hqc_ma_1<-HQIC(ma_1)
aic_ma_2<-AIC(ma_2);bic_ma_2<-BIC(ma_2);hqc_ma_2<-HQIC(ma_2)
aic_arma<-AIC(arma);bic_arma<-BIC(arma);hqc_arma<-HQIC(arma)

aic<-c(aic_ar_1,aic_ar_2,aic_ma_1,aic_ma_2,aic_arma)
bic<-c(bic_ar_1,bic_ar_2,bic_ma_1,bic_ma_2,bic_arma)
hqc<-c(hqc_ar_1,hqc_ar_2,hqc_ma_1,hqc_ma_2,hqc_arma)

tablica<-cbind(aic,bic,hqc)
row.names(tablica)<-c("ar_1","ar_2","ma_1","ma_2","arma")
tablica

#Slika 2.228.
tablica

##########################################################################

# 1.18. pitanja za ponavljanje, zadatak 13:

pod<-read.table("it_dinamicki.txt",sep="\t",header=T)

iip<-ts(pod$it_iip,start=c(1990,1),frequency = 12)
nez<-ts(pod$it_nez,start=c(1990,1),frequency = 12)

s.iip<-diff(log(iip/decompose(iip,type="multiplicative")$seasonal),12)
s.nez<-diff(log(nez/decompose(nez,type="multiplicative")$seasonal),12)

library(dynlm)
dynlm(s.iip~s.nez+L(s.nez)+L(s.iip))

b<-(.21688)
c<-(-.21964)
d<-(.62153)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")
irf<-cumsum(irf)
plot(x,irf,ylab="kumulativno_IRF",xlim=c(0,10),type="l")

dynlm(s.iip~s.nez+L(s.iip))

b<-(.030176)
c<-(0)
d<-(.5936)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")
irf<-cumsum(irf)
plot(x,irf,ylab="kumulativno_IRF",xlim=c(0,10),type="l")


dynlm(s.iip~s.nez+L(s.nez))

b<-(.05019)
c<-(-.102739)
d<-(0)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l")
abline(h=0,lty="dashed")
irf<-cumsum(irf)
plot(x,irf,ylab="kumulativno_IRF",xlim=c(0,10),type="l")

m1<-dynlm(s.iip~s.nez+L(s.iip)+L(s.nez),end=c(2007,12))
m2<-dynlm(s.iip~s.nez+L(s.iip)+L(s.nez),start=c(2008,1))

library(stargazer)
stargazer(list(m1,m2),type="text")



b<-(.412)
c<-(-.375)
d<-(.762)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
x<-0:10
plot(x,irf,ylab="IRF",xlim=c(0,10),type="l",lty="dashed")
abline(h=0,lty="dashed")


b<-(-.04)
c<-(.006)
d<-(.183)
irf<-c(0,b,d*b+c,d*(d*b+c),d^2*(d*b+c),d^3*(d*b+c),d^4*(d*b+c),
       d^5*(d*b+c),d^6*(d*b+c),d^7*(d*b+c),d^8*(d*b+c))
lines(x,irf)
legend("topright",legend=c("1","2"),lty=c(1,2))

library(lmtest)
grangertest(s.iip,s.nez,1)
grangertest(s.iip,s.nez,2)
grangertest(s.iip,s.nez,3)

grangertest(s.nez,s.iip,1)
grangertest(s.nez,s.iip,2)
grangertest(s.nez,s.iip,3)



iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal

lm(iip~nez)

rez<-resid(lm(iip~nez))
rez<-ts(rez,start=c(1990,1),frequency = 12)
library(dynlm)
dynlm(diff(iip)~diff(nez)+L(rez))

library(urca)
summary(ur.df(iip,type="drift",selectlags="BIC"))
summary(ur.df(nez,type="drift",selectlags="BIC"))

summary(ur.df(diff(iip),type="none",selectlags="BIC"))
summary(ur.df(diff(nez),type="none",selectlags="BIC"))

rez2<-resid(lm(iip~nez))
summary(ur.df(rez2,type="none",selectlags = "BIC"))



#################################################################################
# POGLAVLJE 2
#################################################################################

#Primjer 2.3.


pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)

#desezoniranje:
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal

#stope rasta:
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)

#Slika 2.1.

library(vars)
matrica<-cbind(s.iip,s.nez)
m1<-VAR(matrica,p=1,type="const")
summary(m1)

#################################################################################

#Primjer 2.4.


pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)

#desezoniranje:
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal

#stope rasta:
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)
library(vars)
matrica<-cbind(s.iip,s.nez)


#Slika 2.2.

m2<-VAR(matrica,p=2,type="const")
summary(m2)

#################################################################################

#Primjer 2.5


pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)
library(vars)
matrica<-cbind(s.iip,s.nez)
m1<-VAR(matrica,p=1,type="const")

#Slika 2.3.

causality(m1,cause = "s.iip")$Granger
causality(m1,cause = "s.nez")$Granger



m2<-VAR(matrica,p=2,type="const")

#Slika 2.4.

causality(m2,cause = "s.iip")$Granger
causality(m2,cause = "s.nez")$Granger



#################################################################################

#Primjer 2.8

#provesti primjer 2.5.

#slika 2.5.

irf1<-irf(m1,n.ahead=4,ortho=T,ci=0.95,impulse="s.iip",response="s.nez")
irf2<-irf(m1,n.ahead=4,ortho=T,ci=0.95,impulse="s.nez",response="s.iip")
plot(irf1)
plot(irf2)

#slika 2.6. lijevi panel:
plot(irf1)

#slika 2.6. desni panel:
plot(irf2)


irf1<-irf(m1,n.ahead=12,ortho=T,ci=0.95,impulse="s.iip",response="s.nez")
irf2<-irf(m1,n.ahead=12,ortho=T,ci=0.95,impulse="s.nez",response="s.iip")

#slika 2.7. lijevi panel:
plot(irf1)

#slika 2.7. desni panel:
plot(irf2)


#Slika 2.8.

matrica2<-cbind(s.nez,s.iip)
m3<-VAR(matrica2,p=1,type="const")
irf3<-irf(m3,n.ahead=4,ortho=T,ci=0.95,impulse="s.iip",response="s.nez")
irf4<-irf(m3,n.ahead=4,ortho=T,ci=0.95,impulse="s.nez",response="s.iip")
plot(irf3)
plot(irf4)

#slika 2.9. lijeiv panel:
plot(irf3)

#slika 2.9. desni panel:
plot(irf4)


#################################################################################

#Primjer 2.9

#provesti primjer 2.5.

#slika 2.10.
mat2<-cbind(s.nez,s.iip)
var2<-VAR(mat2,p=2,type="const")
irf5<-irf(var2,n.ahead=8,ortho=T,ci=0.95,impulse="s.iip",response="s.nez")
irf6<-irf(var2,n.ahead=8,ortho=T,ci=0.95,impulse="s.nez",response="s.iip")
plot(irf5)
plot(irf6)

#slika 2.11. lijevi panel
plot(irf5)

#slika 2.11. desni panel
plot(irf6)



#################################################################################

#Primjer 2.11


pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)
library(vars)
matrica<-cbind(s.iip,s.nez)
m1<-VAR(matrica,p=1,type="const")

#SLika 2.12.

fevd(m1,n.ahead = 4)


matrica<-cbind(s.nez,s.iip)
m1<-VAR(matrica,p=1,type="const")

#SLika 2.13.

fevd(m1,n.ahead = 4)

#Slika 2.14.
plot(fevd(m1,n.ahead = 12))


#################################################################################

#Primjer 2.12


pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)
library(vars)
matrica<-cbind(s.iip,s.nez)
m1<-VAR(matrica,p=1,type="const")
m2<-VAR(matrica,p=2,type="const")

#slika 2.15.
lr<-(length(s.iip)-2*2+1)*(log(det(summary(m1)$covres))-log(det(summary(m2)$covres)))
lr
pchisq(lr,2^2*(2+1),lower.tail = F)


#################################################################################

#Primjer 2.13


pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)
library(vars)
matrica<-cbind(s.iip,s.nez)

#Slika 2.16.
VARselect(matrica,lag.max=12,type="const")$selection


#################################################################################

#Primjer 2.14


pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)
library(vars)
matrica<-cbind(s.iip,s.nez)
m1<-VAR(matrica,p=1,type="const")


#Slika 2.16., i 2.17.
serial.test(m1, lags.pt=1, type="PT.asymptotic")
serial.test(m1, lags.pt=1, type="PT.adjusted")
serial.test(m1, lags.bg=1, type="BG")
serial.test(m1, lags.bg=1, type="ES")



#################################################################################

#Primjer 2.15

pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)
library(vars)
matrica<-cbind(s.iip,s.nez)
m1<-VAR(matrica,p=1,type="const")

#SLika 2.18.

arch.test(m1,lags.single=1,lags.multi=1,multivariate.only=F)


#################################################################################

#Primjer 2.16

pod<-read.table("rh_dinamicki.txt",sep="\t",header = T)
iip<-ts(pod$hr_iip,start=c(2001,1),frequency = 12)
nez<-ts(pod$hr_nez,start=c(2001,1),frequency = 12)
iip<-iip/decompose(iip,type="multiplicative")$seasonal
nez<-nez/decompose(nez,type="multiplicative")$seasonal
s.iip<-diff(log(iip),12)
s.nez<-diff(log(nez),12)
library(vars)
matrica<-cbind(s.iip,s.nez)
m1<-VAR(matrica,p=1,type="const")

#SLika 2.19.

normality.test(m1,multivariate.only=T)



#################################################################################

# 2.8. Primjer


nizevi<-read.table("var.txt",sep="\t",header = T)
x<-ts(nizevi$x,start=c(2000,1),frequency = 12)
y<-ts(nizevi$y,start=c(2000,1),frequency = 12)

# slika 2.20

library(urca)
summary(ur.df(x,type="drift",selectlags="BIC"))
summary(ur.df(y,type="drift",selectlags="BIC"))

# slika 2.21

library(vars)
matrica<-cbind(x,y)
var1<-VAR(matrica,1,type="const")
summary(var1)

#slika 2.22.

var2<-VAR(matrica,2,type="const")
summary(var2)

# slika 2.23
VARselect(matrica,lag.max = 12,type="const")$selection

library(lmtest)
# slika 2.24

causality(var1,cause="x")$Granger
causality(var1,cause="y")$Granger


# slika 2.25.
plot(irf(var1,n.ahead = 4,ortho=T,ci=.95,impulse="x",response="y"))
plot(irf(var1,n.ahead = 4,ortho=T,ci=.95,impulse="y",response="x"))


#Slika 2.26

fevd(var1,n.ahead=4)

#slika 2.27.
serial.test(var1, lags.pt=4, type="PT.asymptotic")
serial.test(var1, lags.pt=4, type="PT.adjusted")
serial.test(var1, lags.bg=4, type="BG")
serial.test(var1, lags.bg=4, type="ES")

#slika 2.28.

arch.test(var1,lags.single=1,lags.multi=1,multivariate.only=F)


#slika 2.29.

normality.test(var1,multivariate.only = T)


#######################################################

# 2.9. pitanja za ponavljanje, zadatak 25:


nizevi<-read.table("var.txt",sep="\t",header = T)
z<-ts(nizevi$z,start=c(2000,1),frequency = 12)
w<-ts(nizevi$w,start=c(2000,1),frequency = 12)

library(urca)
summary(ur.df(z,type="drift",selectlags="BIC"))
summary(ur.df(w,type="drift",selectlags="BIC"))

library(vars)
matrica<-cbind(z,w)
var1<-VAR(matrica,1,type="const")
summary(var1)

var2<-VAR(matrica,2,type="const")
summary(var2)

VARselect(matrica,lag.max = 12,type="const")$selection

library(lmtest)

causality(var1,cause="z")$Granger
causality(var1,cause="w")$Granger

plot(irf(var1,n.ahead = 4,ortho=T,ci=.95,impulse="z",response="w"))
plot(irf(var1,n.ahead = 4,ortho=T,ci=.95,impulse="w",response="z"))


fevd(var1,n.ahead=4)

serial.test(var1, lags.pt=4, type="PT.asymptotic")
serial.test(var1, lags.pt=4, type="PT.adjusted")
serial.test(var1, lags.bg=4, type="BG")
serial.test(var1, lags.bg=4, type="ES")

arch.test(var1,lags.single=1,lags.multi=1,multivariate.only=F)

normality.test(var1,multivariate.only = T)



#################################################################################
# POGLAVLJE 3
#################################################################################


# primjer 3.1.

# slika 3.1.


vec<-read.table("vec.txt",header = T, sep="\t")
y1<-ts(vec$y1,start=c(2002,1),frequency = 12)
y2<-ts(vec$y2,start=c(2002,1),frequency = 12)
y3<-ts(vec$y3,start=c(2002,1),frequency = 12)
y4<-ts(vec$y4,start=c(2002,1),frequency = 12)
library(urca)
summary(ur.df(y1,type="drift",selectlags="BIC"))@teststat[1,1];
summary(ur.df(y2,type="drift",selectlags="BIC"))@teststat[1,1];
summary(ur.df(y3,type="drift",selectlags="BIC"))@teststat[1,1];
summary(ur.df(y4,type="drift",selectlags="BIC"))@teststat[1,1]


library(vars)
library(tsDyn)

#slika 3.2.

m1<-cbind(y1,y4)
VARselect(m1,12,type="none")$selection
vec1<-VECM(m1,lag=0,include="none",LRinclude="none",estim="ML")
summary(rank.test(vec1))

# slika 3.3

m2<-cbind(y2,y4)
VARselect(m2,12,type="none")$selection
vec2<-VECM(m2,lag=0,include="none",LRinclude="none",estim="ML")
summary(rank.test(vec2))


#slika 3.4.


m3<-cbind(y3,y1)
VARselect(m3,12,type="none")$selection
vec3<-VECM(m3,lag=0,include="none",LRinclude="none",estim="ML")
summary(rank.test(vec3))

#slika 3.5.


summary(vec2)
summary(vec2)$coefMat

#slika 3.6.

var<-VAR(diff(m3),p=1,type="none")
plot(irf(var,impulse="y1",response="y3",ci=0.95,n.ahead=4,ortho=T))
plot(irf(var,impulse="y3",response="y1",ci=0.95,n.ahead=4,ortho=T))


#slika 3.7 lijevi panel

plot(irf(var,impulse="y1",response="y3",ci=0.95,n.ahead=4,ortho=T))

#slika 3.7. desni panel

plot(irf(var,impulse="y3",response="y1",ci=0.95,n.ahead=4,ortho=T))

# slika 3.8.

m4<-cbind(y1,y2,y3)
vec4<-VECM(m4,lag=1,r=2,include="none",LRinclude="none",estim="ML")
summary(vec4)

# slika 3.9.

m4<-cbind(y1,y2,y3)
vec4<-VECM(m4,lag=1,r=2,include="const",LRinclude="none",estim="ML")
summary(vec4)

# slika 3.10. prvi red prvi stupac

plot(irf(vec4,impulse="y1",response="y2",ci=0.95,n.ahead=4,ortho=T))

# slika 3.10. prvi red drugi stupac

plot(irf(vec4,impulse="y1",response="y3",ci=0.95,n.ahead=4,ortho=T))

# slika 3.10. drugi red prvi stupac

plot(irf(vec4,impulse="y2",response="y1",ci=0.95,n.ahead=4,ortho=T))

# slika 3.10. drugi red drugi stupac

plot(irf(vec4,impulse="y2",response="y3",ci=0.95,n.ahead=4,ortho=T))

# slika 3.10. treći red prvi stupac

plot(irf(vec4,impulse="y3",response="y1",ci=0.95,n.ahead=4,ortho=T))

# slika 3.10. treći red drugi stupac

plot(irf(vec4,impulse="y3",response="y2",ci=0.95,n.ahead=4,ortho=T))


#################################################################

#Primjer 3.2.


vec<-read.table("vec.txt",header = T, sep="\t")
y1<-ts(vec$y1,start=c(2002,1),frequency = 12)
y2<-ts(vec$y2,start=c(2002,1),frequency = 12)
y3<-ts(vec$y3,start=c(2002,1),frequency = 12)
y4<-ts(vec$y4,start=c(2002,1),frequency = 12)

library(tsDyn)
m2<-cbind(y2,y4)

#slika 3.11.

vec6<-VECM(m2,lag=0,include="const",LRinclude="none",estim="ML")
summary(vec6)


#################################################################

# 3.4. primjer

# slika 3.12.

vec<-read.table("vec_primjer.txt",header = T, sep="\t")
x<-ts(vec$x,start=c(2003,1),frequency = 12)
y1<-ts(vec$y1,start=c(2003,1),frequency = 12)
y2<-ts(vec$y2,start=c(2003,1),frequency = 12)

library(urca)
summary(ur.df(x,type="drift",selectlags = "BIC"))
summary(ur.df(y1,type="drift",selectlags = "BIC"))
summary(ur.df(y2,type="drift",selectlags = "BIC"))

library(vars)
library(tsDyn)
# slika 3.13
m1<-cbind(x,y1)
VARselect(m1,12,type="none")$selection
vec1<-VECM(m1,lag=0,include="none",LRinclude="none",estim="ML")
summary(rank.test(vec1))


#SLika 3.14.

m2<-cbind(x,y2)
VARselect(m2,12,type="none")$selection
vec2<-VECM(m2,lag=0,include="none",LRinclude="none",estim="ML")
summary(rank.test(vec2))

# slika 3.15.
summary(vec2)
coefA(vec2); coefB(vec2);coefPI(vec2)
vec2

# slika 3.16.

var2<-VAR(diff(m2),type="none",p=1)
plot(irf(var2,impulse = "x",response = "y2",ci=.95,n.ahead=4,ortho = T))
plot(irf(var2,impulse = "y2",response = "x",ci=.95,n.ahead=4,ortho = T))

# slika 3.17
vec3<-VECM(m2,lag=0,include="const",LRinclude="none",estim="ML")
summary(rank.test(vec3))

# slika 3.18.
vec4<-VECM(m2,lag=1,include="const",LRinclude="none",estim="ML")
summary(rank.test(vec4))

# slika 3.19.

plot(irf(vec4,impulse="x",response="y2",ci=0.95,n.ahead=4,ortho=T))
plot(irf(vec4,impulse="y2",response="x",ci=0.95,n.ahead=4,ortho=T))

# slika 3.20

m3<-cbind(x,y1,y2)
vec5<-VECM(m3,lag=0,r=2,include="none",LRinclude="const",estim="ML")
summary(vec5)
coefA(vec5);coefB(vec5);coefPI(vec5)



#################################################################

# 3.5. pitanja za ponavljanje, zadatak 6

data<-read.table("vec_vjezba.txt",sep="\t",header=T)
x<-ts(data$x,start=c(2003,1),frequency = 12)
y1<-ts(data$y1,start=c(2003,1),frequency = 12)
y2<-ts(data$y2,start=c(2003,1),frequency = 12)

library(urca)
summary(ur.df(x,type="drift",selectlags = "BIC"))
summary(ur.df(y1,type="drift",selectlags = "BIC"))
summary(ur.df(y2,type="drift",selectlags = "BIC"))

library(vars)
library(tsDyn)
m1<-cbind(x,y1)
VARselect(m1,12,type="none")$selection
vec1<-VECM(m1,lag=0,include="none",LRinclude="none",estim="ML")
summary(rank.test(vec1))


m2<-cbind(x,y2)
VARselect(m2,12,type="none")$selection
vec2<-VECM(m2,lag=0,include="none",LRinclude="none",estim="ML")
summary(rank.test(vec2))

summary(vec2)
coefA(vec2); coefB(vec2);coefPI(vec2)
vec2

var2<-VAR(diff(m2),type="none",p=1)
plot(irf(var2,impulse = "x",response = "y2",ci=.95,n.ahead=4,ortho = T))
plot(irf(var2,impulse = "y2",response = "x",ci=.95,n.ahead=4,ortho = T))


vec3<-VECM(m2,lag=0,include="const",LRinclude="none",estim="ML")
summary(rank.test(vec3))


vec4<-VECM(m2,lag=1,include="const",LRinclude="none",estim="ML")
summary(rank.test(vec4))


plot(irf(vec4,impulse="x",response="y2",ci=0.95,n.ahead=4,ortho=T))
plot(irf(vec4,impulse="y2",response="x",ci=0.95,n.ahead=4,ortho=T))

m3<-cbind(x,y1,y2)
vec5<-VECM(m3,lag=0,r=2,include="none",LRinclude="const",estim="ML")
summary(vec5)
coefA(vec5);coefB(vec5);coefPI(vec5)